import discord
import ezcord
import discord.utils
from discord.ext import commands

from essentials import bot_plugins
from cogs.utils import check_status


class Welcome(commands.Cog):
    def __init__(self, bot: ezcord.Bot):
        self.bot = bot

        #self.methode = None
        #self.channel = None

    
    @commands.Cog.listener()
    async def on_ready(self):
        await bot_plugins.add_plugin(self.__class__.__name__)

        print(self.bot.intents.members)


    @commands.Cog.listener()
    async def on_message(self, message):
        print("message")


    @commands.Cog.listener()
    async def on_member_join(self, member):

        guild = member.guild

        channel = guild.get_channel(1226960148652884133)

        state = await check_status(self.__class__.__name__)

        if state == "maintenance":
            await channel.send("Test")
            return

        if self.methode == "text":
            await self.channel.send("Text")

        elif self.methode == "embed":
            await self.channel.send("Embed")

        elif self.methode == "picture":
            await self.channel.send("Picture")

        else:
            pass



async def setup(bot: ezcord.Bot):
    await bot.add_cog(Welcome(bot))