#!/bin/bash

# Session Name
SESSION_NAME="Lunar"

# Enable Enviroment Command
ENVIROMENT_COMMAND="source /server/development/lunar_bot/env/bin/activate"

# Start Program Commands
START_PANEL="/server/development/lunar_bot/env/bin/python /server/development/lunar_bot/main.py"
START_BOT="/server/development/lunar_bot/env/bin/python /server/development/lunar_bot/bot.py"

# Start Tmux Session
tmux new-session -d -s "$SESSION_NAME"

# Send Commands for First Programm
tmux send-keys -t "$SESSION_NAME" "$ENVIROMENT_COMMAND" Enter
tmux send-keys -t "$SESSION_NAME" "$START_PANEL" Enter

# Split Screen
tmux split-window -h -p50 -t "$SESSION_NAME"

# Send Commands for Second Programm
tmux send-keys -t "$SESSION_NAME" "$ENVIROMENT_COMMAND" Enter
tmux send-keys -t "$SESSION_NAME" "$START_BOT" Enter

# Switch Into Session
tmux attach -t "$SESSION_NAME"