import asyncio
import aiocron
from async_timeout import timeout

import yaml
from yaml.loader import SafeLoader

import discord
import discord.utils
from discord import option
from discord.ext import commands

import mysql.connector
from mysql.connector import Error

import time
from datetime import date, datetime, tzinfo

import os

import flask

from easy_pil import Canvas, Editor, Font, Text, font, load_image_async
from PIL import Image, ImageDraw, ImageFont, ImageOps
import pytz
import socket

import youtube_dl

from cogs.database import select_database

import logging

logging.getLogger('youtube_dl').setLevel(logging.WARNING)
logging.getLogger('youtube_dl.utils').setLevel(logging.ERROR)

zeit = datetime.now()

time_date = zeit.strftime("%Y/%m/%d")
time_year = zeit.strftime("%Y")
time_month = zeit.strftime("%m")
time_day = zeit.strftime("%d")

time_time = zeit.strftime("%H:%M:%S")
time_hour = zeit.strftime("%H")
time_minute = zeit.strftime("%M")
time_second = zeit.strftime("%S")

time_datetime = zeit.strftime("%Y/%m/%d" "%H:%M:%S")

## Class

class Music(commands.Cog):
    
    def __init__(self, bot):
        self.bot = bot
        global path
        path = bot.path


    @commands.slash_command(name="play", description="Spiele einen track")
    async def play(
        self, ctx: discord.ApplicationContext, search
        ):
        with open(fr'{path}/Configs/server.yaml', encoding='utf8') as f:
            data = yaml.load(f, Loader=SafeLoader)
            try:
                servername = next(item["name"] for item in data["Config.Server"] if str(ctx.guild.id) == str(item["guild"]))
            except StopIteration:
                ctx.respond("Error in Syntax", ephemeral=True)
                return
            
        if search == None or search == "":
            await ctx.respond("You had to provide a name or a link")

        elif search.startswith("https://"):
            sql = f"SELECT song_id FROM songs WHERE link = '{search}'"
            checkback_database = await select_database(servername, sql)
            await download(search, number)

        else:
            await get_link(search)


async def get_link(name):
    pass
        

async def download(url, number):
    number = number + 1
    ydl_opts = {
        'format': 'bestaudio/best',
        'outtmpl': f'{path}/music/{number}.mp3',
        'ignoreerrors': True,
    }
    with youtube_dl.YoutubeDL(ydl_opts) as ydl:
        info = ydl.extract_info(url, download=True)
        if 'entries' in info:
            info = info['entries'][0]

    if info.get('title') and info.get('uploader') != None:
        metadata = {'artist': f'{info["uploader"]}', 'title': f'{info["title"]}', 'name': f'{number}'}

        with open(fr'{path}/Configs/songs.yaml', encoding='utf8', mode='r') as file:
            config = yaml.safe_load(file)

        config["Config.Songs"][url] = metadata

        with open(fr'{path}/Configs/songs.yaml', encoding='utf8', mode='w') as file:
            yaml.dump(config, file, default_flow_style=False)


async def connect(self):
    pass


def setup(bot):
    bot.add_cog(Music(bot))