import discord
import ezcord
import os
import yaml
from discord.ext.ipc.server import Server, ClientPayload
from dotenv import load_dotenv



class Bot(ezcord.Bot):
    def __init__(self):
        super().__init__()
        self.ipc = Server(self, secret_key="SECRET_KEY")

        with open("locales/en.yaml", encoding="UTF-8") as file:
            en = yaml.safe_load(file)

        with open("locales/de.yaml", encoding="UTF-8") as file:
            de = yaml.safe_load(file)

        with open("locales/fi.yaml", encoding="UTF-8") as file:
            fi = yaml.safe_load(file)


        locales = {"en":en, "de":de, "fi":fi}
        ezcord.i18n.I18N(locales, fallback_locale="en")


    async def on_ready(self):
        await self.ipc.start()



    async def on_ipc_error(self, endpoint: str, exc: Exception):
        raise exc
    

    @Server.route()
    async def guild_stats(self, data: ClientPayload):
        guild = self.get_guild(data.guild_id)
        if not guild:
            return {
                "member_count": "Bot is not on this Server",
                "name": "Unbekannt"
            }

        return {
            "member_count": guild.member_count,
            "name": guild.name,
        }



if __name__ == "__main__":
    bot = ezcord.Bot(discord.Intents.all())

    bot.load_cogs(
        subdirectories=True,
        ignored_cogs=[]
        )

    load_dotenv()
    bot.run(os.getenv("BOT_TOKEN"))