import asyncio
import aiocron
from async_timeout import timeout

import yaml
from yaml.loader import SafeLoader

import discord
import discord.utils
from discord import option
from discord.ext import commands

import mysql.connector
from mysql.connector import Error

import time
from datetime import date, datetime, tzinfo

import os

import flask

from easy_pil import Canvas, Editor, Font, Text, font, load_image_async
from PIL import Image, ImageDraw, ImageFont, ImageOps
import pytz
import socket

from cogs.messagebuilder import createembed

zeit = datetime.now()

time_date = zeit.strftime("%Y/%m/%d")
time_year = zeit.strftime("%Y")
time_month = zeit.strftime("%m")
time_day = zeit.strftime("%d")

time_time = zeit.strftime("%H:%M:%S")
time_hour = zeit.strftime("%H")
time_minute = zeit.strftime("%M")
time_second = zeit.strftime("%S")

time_datetime = zeit.strftime("%Y/%m/%d" "%H:%M:%S")



## Class

class Cooperatedesigns(commands.Cog):
    
    def __init__(self, bot):
        self.bot = bot
        global path
        path = bot.path


    @commands.slash_command(name="cooperatedesigns", description="Zeigt alle Cooperatedesigns für den Server an.")
    async def cooperatedesigns(
        self, ctx: discord.ApplicationContext
        ):
        with open(fr'{path}/Configs/server.yaml', encoding='utf8') as f:
            data = yaml.load(f, Loader=SafeLoader)
            try:
                servername = next(item["name"] for item in data["Config.Server"] if str(ctx.guild.id) == str(item["guild"]))
            except StopIteration:
                await ctx.respond("Error in Syntax", ephemeral=True)
                return
            
            with open(fr'{path}/Configs/{servername}/cooperatedesigns.yaml', encoding='utf8') as f:
                data = yaml.load(f, Loader=SafeLoader)

            if data["Config.Base"].lower() == "text":
                await ctx.respond(data["Config.Text"]["text"], ephemeral=True)

            elif data["Config.Base"].lower() == "embed":
                Embed = await createembed(path, servername, "cooperatedesigns.yaml", "Config.Text", None, ctx.user, None, None, None)

                await ctx.respond(embed=Embed, ephemeral=True)

            else:
                ctx.respond("the config file has an error in the Config.Base statement!", ephemeral=True)

                return False
            


def setup(bot):
    bot.add_cog(Cooperatedesigns(bot))