import asyncio
import aiocron
from async_timeout import timeout

import yaml
from yaml.loader import SafeLoader

import discord
import discord.utils
from discord import option
from discord.ext import commands

import mysql.connector
from mysql.connector import Error

import time
from datetime import date, datetime, tzinfo

import os

import flask

from easy_pil import Canvas, Editor, Font, Text, font, load_image_async
from PIL import Image, ImageDraw, ImageFont, ImageOps
import pytz
import socket

from cogs.encrypting import encode, decode, encrypt, decrypt
from cogs.database import select_database, insert_database, update_database
from cogs.messagebuilder import createembed

zeit = datetime.now()

time_date = zeit.strftime("%Y/%m/%d")
time_year = zeit.strftime("%Y")
time_month = zeit.strftime("%m")
time_day = zeit.strftime("%d")

time_time = zeit.strftime("%H:%M:%S")
time_hour = zeit.strftime("%H")
time_minute = zeit.strftime("%M")
time_second = zeit.strftime("%S")

time_datetime = zeit.strftime("%Y/%m/%d" "%H:%M:%S")



## Class

class Embedcreator(commands.Cog):
    
    def __init__(self, bot):
        self.bot = bot
        global path
        path = bot.path



    @commands.slash_command(name="embed", description="Senden einer Voreingestellten Embedmessage")
    @option("text", description="Welcher Text soll gesendet werden?")
    async def embed(
        self, ctx: discord.ApplicationContext,
        text = str
        ):
        with open(fr'{path}/Configs/server.yaml', encoding='utf8') as f:
            data = yaml.load(f, Loader=SafeLoader)
            try:
                servername = next(item["name"] for item in data["Config.Server"] if str(ctx.guild.id) == str(item["guild"]))
            except StopIteration:
                ctx.respond("Error in Syntax", ephemeral=True)
                return
            
            Embed = await createembed(path, servername, f"text/{text}.yaml", "Config.Text", None, None, None, None, None)

            await ctx.respond(embed=Embed)



def setup(bot):
    bot.add_cog(Embedcreator(bot))