import asyncio
import aiocron
from async_timeout import timeout

import yaml
from yaml.loader import SafeLoader

import discord
import discord.utils
from discord import option
from discord.ext import commands

import mysql.connector
from mysql.connector import Error

import time
from datetime import date, datetime, tzinfo

import os

import flask

from easy_pil import Canvas, Editor, Font, Text, font, load_image_async
from PIL import Image, ImageDraw, ImageFont, ImageOps
import pytz
import socket

import youtube_dl

from cogs.database import select_database

import logging

logging.getLogger('youtube_dl').setLevel(logging.WARNING)
logging.getLogger('youtube_dl.utils').setLevel(logging.ERROR)

zeit = datetime.now()

time_date = zeit.strftime("%Y/%m/%d")
time_year = zeit.strftime("%Y")
time_month = zeit.strftime("%m")
time_day = zeit.strftime("%d")

time_time = zeit.strftime("%H:%M:%S")
time_hour = zeit.strftime("%H")
time_minute = zeit.strftime("%M")
time_second = zeit.strftime("%S")

time_datetime = zeit.strftime("%Y/%m/%d" "%H:%M:%S")

## Class

class Fractions(commands.Cog):
    
    def __init__(self, bot):
        self.bot = bot
        global path
        path = bot.path


    @commands.slash_command(name="jobranks", description="Verwalten der Job-Ränge")
    @option("kategorie_ID", description="Für welche Kategorie sollen die Ränge verwaltet werden?")
    async def jobranks(
        self, ctx: discord.ApplicationContext,
        cathegory = str,
        ):
        with open(fr'{path}/Configs/server.yaml', encoding='utf8') as f:
            data = yaml.load(f, Loader=SafeLoader)
        try:
            servername = next(item["name"] for item in data["Config.Server"] if str(ctx.guild.id) == str(item["guild"]))
        except StopIteration:
            ctx.respond("Error in Syntax", ephemeral=True)
            return
        
        await showranks(ctx, cathegory, servername)




async def showranks(ctx, cathegory, servername):
    with open(fr'{path}/Configs/{servername}/fractions.yaml', encoding='utf8') as f:
        data = yaml.load(f, Loader=SafeLoader)

    category = ctx.guild.get_channel(int(cathegory))

    if category.permissions_for(ctx.user).manage_channels:
        Embed = discord.Embed(
            title='Job Ränge Verwalten',
            description='Hier kannst du deine Jobränge Verwalten',
            color=int('113c97', 16)
        )
        Embed.add_field(
            name=f'cathegory1',
            value=f'```Value```',
            inline=False
        )
        Embed.add_field(
            name=f'cathegory2',
            value=f'```Value```',
            inline=False
        )
        Embed.add_field(
            name=f'cathegory3',
            value=f'```Value```',
            inline=False
        )
        Embed.add_field(
            name=f'cathegory4',
            value=f'```Value```',
            inline=False
        )
        Embed.set_footer(text='Herzliche Grüße Ihr 24seven Team')
        
        await ctx.respond(embed=Embed, ephemeral=True)

    else:
        await ctx.respond('Du besitzt nicht die Berechtigung um Ränge für diese Kategorie zu bearbeiten.', ephemeral=True)



def setup(bot):
    bot.add_cog(Fractions(bot))