import asyncio
import aiocron
from async_timeout import timeout

import yaml
from yaml.loader import SafeLoader

import discord
import discord.utils
from discord import option
from discord.ext import commands

import mysql.connector
from mysql.connector import Error

import time
from datetime import date, datetime, tzinfo

import os

import flask

from easy_pil import Canvas, Editor, Font, Text, font, load_image_async
from PIL import Image, ImageDraw, ImageFont, ImageOps
import pytz
import socket

from cogs.encrypting import encode, decode, encrypt, decrypt
from cogs.database import select_database, insert_database, update_database

zeit = datetime.now()

time_date = zeit.strftime("%Y/%m/%d")
time_year = zeit.strftime("%Y")
time_month = zeit.strftime("%m")
time_day = zeit.strftime("%d")

time_time = zeit.strftime("%H:%M:%S")
time_hour = zeit.strftime("%H")
time_minute = zeit.strftime("%M")
time_second = zeit.strftime("%S")

time_datetime = zeit.strftime("%Y/%m/%d" "%H:%M:%S")



## Class

class Passwords(commands.Cog):
    
    def __init__(self, bot):
        self.bot = bot
        global path
        path = bot.path


    @commands.slash_command(name="passwords", description="Senden eigener Passwörter")
    async def passwords(
        self, ctx: discord.ApplicationContext
        ):
        homedir = path.split("/")
        try:
            with open(fr'/{homedir[1]}/sys-admin/logindata/data.yaml', encoding='utf8') as f:
                data = yaml.load(f, Loader=SafeLoader)
        except Exception as e:
            print(e)
            pass

        length = len(data["config.user"])

        Embed = discord.Embed(
            title="24Seven-logindata",
            description="Hier siehst du alle deine Passwörter welche von den Admins für dich freigeschaltet wurden!\n\n",
            color=int("113c97", 16)
        )
        Embed.set_footer(text="Herzliche Grüße Ihr 24seven Team")

        for i in data["config.user"]:
            if str(ctx.user.id) in data["config.user"][str(i)]["allowed_ids"]:
                Embed.add_field(
                    name=f'ssh - login | {i} |',
                    value=f'username:\n```{data["config.user"][str(i)]["ssh"]["username"]}```password:\n```{data["config.user"][str(i)]["ssh"]["password"]}```',
                    inline=True
                )
                Embed.add_field(
                    name=f'database - login',
                    value=f'username:\n```{data["config.user"][str(i)]["database"]["username"]}```password:\n```{data["config.user"][str(i)]["database"]["password"]}```',
                    inline=True
                )
                Embed.add_field(
                    name=f'txadmin - login',
                    value=f'username:\n```{data["config.user"][str(i)]["txadmin"]["username"]}```password:\n```{data["config.user"][str(i)]["txadmin"]["password"]}```',
                    inline=True
                )

        await ctx.respond(embed=Embed, ephemeral=True)



def setup(bot):
    bot.add_cog(Passwords(bot))