import asyncio
import aiocron
from async_timeout import timeout

import yaml
from yaml.loader import SafeLoader

import discord
import discord.utils
from discord import option
from discord.ext import commands

import mysql.connector
from mysql.connector import Error

import time
from datetime import date, datetime, tzinfo

import os

import flask

from easy_pil import Canvas, Editor, Font, Text, font, load_image_async
from PIL import Image, ImageDraw, ImageFont, ImageOps
import pytz
import socket

from cogs.encrypting import encode, decode, encrypt, decrypt
from cogs.database import select_database, insert_database, update_database
from cogs.messagebuilder import createembed

zeit = datetime.now()

time_date = zeit.strftime("%Y/%m/%d")
time_year = zeit.strftime("%Y")
time_month = zeit.strftime("%m")
time_day = zeit.strftime("%d")

time_time = zeit.strftime("%H:%M:%S")
time_hour = zeit.strftime("%H")
time_minute = zeit.strftime("%M")
time_second = zeit.strftime("%S")

time_datetime = zeit.strftime("%Y/%m/%d" "%H:%M:%S")



## Class

class Tickets(commands.Cog):
    
    def __init__(self, bot):
        self.bot = bot
        global path
        path = bot.path



    @commands.slash_command(name="tickets", description="Senden der Tickets-Nachricht")
    async def tickets(
        self, ctx = discord.ApplicationContext):

        with open(fr'{path}/Configs/server.yaml', encoding='utf8') as f:
            data = yaml.load(f, Loader=SafeLoader)
            try:
                servername = next(item["name"] for item in data["Config.Server"] if str(ctx.guild.id) == str(item["guild"]))
                checkback = await check_send(servername)
            except StopIteration:
                await ctx.respond("Error in Syntax", ephemeral=True)
                return
            
            if checkback is not None and checkback is not False:
                backsend = await send_ticket(ctx, servername, checkback, self.bot)
                await ctx.respond(backsend, ephemeral=True)



#    @commands.slash_command(name="ticket close", description="Schließen des Tickets")
#    @option("channelid", description="Welches Ticket wollen sie Schließen?")
#    async def ticketclose(self, ctx = discord.ApplicationContext):
#
#        with open(fr'{path}/Configs/server.yaml', encoding='utf8') as f:
#            data = yaml.load(f, Loader=SafeLoader)
#            try:
#                servername = next(item["name"] for item in data["Config.Server"] if str(ctx.guild.id) == str(item["guild"]))
#            except StopIteration:
#                await ctx.respond("Error in Syntax", ephemeral=True)
#                return
            




async def check_send(servername):
    with open(fr'{path}/Configs/{servername}/tickets.yaml', encoding='utf8') as f:
        data = yaml.load(f, Loader=SafeLoader)

    if data["Config.Enabled"] == True:

        if data["Config.Base"] == "Text":
            methode = "Text"

        elif data["Config.Base"] == "Embed":
            methode = "Embed"

        else:
            methode = None


        if data["Config.Element"] == "Button":
            interactobject = "Button"

        elif data["Config.Element"] == "Dropdown":
            interactobject = "Dropdown"

        else:
            methode = None

        if methode is not None:
            checkback = [methode, interactobject]
            return checkback
        
        else:
            return False

    else:
        return
 


async def send_ticket(ctx, servername, base, bot):
    with open(fr'{path}/Configs/{servername}/tickets.yaml', encoding='utf8') as f:
        data = yaml.load(f, Loader=SafeLoader)

    guild = bot.get_guild(int(ctx.guild.id))
    channel = guild.get_channel(int(data["Config.Channel"]))

    methode = base[0]
    interactobject = base[1]

    Embed = await createembed(path, servername, "tickets.yaml", "Config.Text", None, None, None, None, channel)

    if interactobject == "Button":
        view = discord.ui.View(timeout=None)
        view.add_item(TicketButton(servername))
        await channel.send(embed=Embed, view=view)

    if interactobject == "Dropdown":
        await channel.send(embed=Embed)

    backsend = data["Config.Messages"]["message_send"]
    return backsend



async def send_answermessage(interaction, user, channelobj, thread, data, servername):
    if data["Config.Base"] == "Text":
        methode = "Text"

    elif data["Config.Base"] == "Embed":
        methode = "Embed"

    else:
        None

    if methode == "Embed":
        if thread is not None:
            channel = thread
        else:
            channel = interaction.guild.get_channel(channelobj.id)

        Embed = await createembed(path, servername, "tickets.yaml", "Config.Answer", None, user, None, None, channel)

        if interaction.response.is_done():
            await interaction.followup.send(embed=Embed, ephemeral=True)
        else:
            await interaction.response.send_message(embed=Embed, ephemeral=True)

        return True
    
    else:
        return False



async def create_ticketmessage(interaction, user, data, servername):
    if data["Config.Base"] == "Text":
        methode = "Text"

    elif data["Config.Base"] == "Embed":
        methode = "Embed"

    else:
        None


    if methode == "Embed":
        Embed = await createembed(path, servername, "tickets.yaml", "Config.Ticket", None, user, None, None, None)

        view = discord.ui.View(timeout=None)

        view.add_item(TicketCloseButton(servername))
        view.add_item(TicketInviteButton(servername))

        if data["Config.EditorButton"] == True:
            view.add_item(TicketAddEditorButton(servername))

        return Embed, view


async def create_threadheader(interaction, user, data, servername):
    if data["Config.Base"] == "Text":
        methode = "Text"

    elif data["Config.Base"] == "Embed":
        methode = "Embed"

    else:
        None


    if methode == "Embed":
            #Embed = await createembed(path, servername, "tickets.yaml", "Config.Ticket", None, user, None, None, None)

            Embed = discord.Embed()

            Embed.title = "Admin / Supporter Panel | Comming Soon"

            Embed.set_footer(text=f"Bitte haben Sie gedult.")

            return Embed



async def send_threadmessage(interaction, user, channel, data, servername):
    if data["Config.Base"] == "Text":
        methode = "Text"

    elif data["Config.Base"] == "Embed":
        methode = "Embed"

    else:
        None


    if methode == "Embed":
        Embed = await createembed(path, servername, "tickets.yaml", "Config.Ticket", None, user, None, None, channel)

        view = discord.ui.View(timeout=None)

        view.add_item(TicketCloseButton(servername))
        view.add_item(TicketInviteButton(servername))

        if data["Config.EditorButton"] == True:
            view.add_item(TicketAddEditorButton(servername))

        await channel.send(embed=Embed, view=view)

        return True
    
    else:
        return False
    


async def send_ticketmessage(interaction, user, channelobj, data, servername):
    if data["Config.Base"] == "Text":
        methode = "Text"

    elif data["Config.Base"] == "Embed":
        methode = "Embed"

    else:
        None


    if methode == "Embed":
        channel = interaction.guild.get_channel(channelobj.id)

        Embed = await createembed(path, servername, "tickets.yaml", "Config.Ticket", None, user, None, None, channel)

        view = discord.ui.View(timeout=None)

        view.add_item(TicketCloseButton(servername))
        view.add_item(TicketInviteButton(servername))

        if data["Config.EditorButton"] == True:
            view.add_item(TicketAddEditorButton(servername))

        await channel.send(embed=Embed, view=view)

        return True
    
    else:
        return False
    


async def send_invitemessage(interaction, user, member, channel, data, servername):
    if data["Config.Base"] == "Text":
        methode = "Text"

    elif data["Config.Base"] == "Embed":
        methode = "Embed"

    else:
        None
 

    if methode == "Embed":
        Embed = await createembed(path, servername, "tickets.yaml", "Config.Invite", None, user, member, interaction.message.id, channel)

        view = discord.ui.View(timeout=None)

        view.add_item(TicketInviteAcceptButton(servername))
        view.add_item(TicketInviteDeclineButton(servername))

        if interaction.response.is_done():
            await interaction.followup.send(embed=Embed, view=view)
        else:
            await interaction.response.send_message(embed=Embed, view=view)

        return True
    
    else:
        return False



async def create_ticket(interaction, user, data):
    try:
        categoryid = data["Config.Categoryid"]
        category = interaction.client.get_channel(int(data["Config.Category"][categoryid]["categoryid"]))
    except Exception:
        pass

    if category is not None:
        channel_topics = [channel.topic for channel in interaction.guild.text_channels]

        if str(user.id) in channel_topics:
            if interaction.response.is_done():
                await interaction.followup.send("Sie haben Bereits ein geöffnetes Ticket", ephemeral=True)
                return False
            else:
                await interaction.response.send_message("Sie haben Bereits ein geöffnetes Ticket", ephemeral=True)
                return False
        
        else:
            ticketchannel = await interaction.guild.create_text_channel(f"Support-Ticket-{user.name}", topic=str(user.id), category=category)
            return ticketchannel

    else:
        if interaction.response.is_done():
            await interaction.followup.send("Error in Syntax", ephemeral=True)
        else:
            await interaction.response.send_message("Error in Syntax", ephemeral=True)
        return False



async def create_thread(interaction, user, data, Embed):
    try:
        categoryid = data["Config.Categoryid"]
        category = interaction.client.get_channel(int(data["Config.Category"][categoryid]["categoryid"]))
    except Exception:
        pass

    ticketthread = await category.create_thread(name=f"Ticket - {user.name}", embed=Embed)
    return ticketthread
    



async def overwrite_ticket(interaction, user, channel, data):
    overwrites = {}

    for group in data["Config.Permissions"]:
        if group == "default":
            role = interaction.guild.default_role

            permissions = data["Config.Permissions"][group]["permissions"]
            for key, value in permissions.items():
                overwrites[role] = discord.PermissionOverwrite(**permissions)


        elif group == "user":
            permissions = data["Config.Permissions"][group]["permissions"]
            for key, value in permissions.items():
                overwrites[user] = discord.PermissionOverwrite(**permissions)


        elif group == "roles":
            length = len(data["Config.Permissions"][group])
            for i in range(0, length, 1):
                role = interaction.guild.get_role(int(data["Config.Permissions"][group][i]["roleid"]))

                permissions = data["Config.Permissions"][group][i]["permissions"]
                for key, value in permissions.items():
                    overwrites[role] = discord.PermissionOverwrite(**permissions)


    if overwrites == {}:
        return False

    await channel.edit(overwrites=overwrites)
    return True



async def close_ticket(ctx, channelid):
    channel = ctx.guild.get_channel(channelid)
    try:
        await ctx.channel.delete()
    except Exception as e:
        return e
    
    return True



async def invite_member(interaction, Embed, data):
    members = []

    for field in Embed.fields:
        if field.value.startswith("<@"):
            member_id = field.value.split("<@")[1].split(">")[0]
            members.append(member_id)
    
    original_message_id = interaction.message.reference.message_id
    original_message = await interaction.channel.fetch_message(original_message_id)

    Embed = original_message.embeds[0]
    length = len(Embed.fields) - 1

    for memberid in members:
        try:
            member = interaction.guild.get_member(int(memberid))
        except Exception:
            return False

        if member == interaction.user:
            pass

        else:
            if str(interaction.channel.type) == "public_thread":
                await single_ghost_ping(interaction, interaction.channel, member)

            else:
                permissions = data["Config.Permissions"]["user"]["permissions"]
                await interaction.channel.set_permissions(member, **permissions)

            if "None" in Embed.fields[length].value:
                Embed.set_field_at(length, name=Embed.fields[length].name, value=Embed.fields[length].value.replace(Embed.fields[length].value, member.mention), inline=Embed.fields[length].inline)

            else:
                Embed.set_field_at(length, name=Embed.fields[length].name, value=Embed.fields[length].value + "\n" + member.mention, inline=Embed.fields[length].inline)

    await original_message.edit(embed=Embed)

    if interaction.response.is_done():
        await interaction.followup.send("Invite Accepted", ephemeral=True)
    else:
        await interaction.response.send_message("Invite Accepted", ephemeral=True)

    return True
            
    

async def create_transcript(interaction, data):
    messages = []
    async for message in interaction.channel.history(limit=None, oldest_first=True):
        messages.append(message)

    transcript_content = ""
    for message in reversed(messages):
        timestamp = message.created_at.strftime("%Y-%m-%d %H:%M:%S")
        author = message.author.display_name
        content = message.content

        transcript_content += f"[{timestamp}] {author}: {content}\n"

        for attachment in message.attachments:
            transcript_content += f"[{timestamp}] {author}: {attachment.url}\n"

    await interaction.user.send(transcript_content)

    return True



async def add_editor(interaction, Embed, data):
    length = len(Embed.fields) - 2

    if str(interaction.channel.type) == "public_thread":
        await single_ghost_ping(interaction, interaction.channel, interaction.user)

    else:
        permissions = data["Config.Permissions"]["editor"]["permissions"]
        await interaction.channel.set_permissions(interaction.user, **permissions)

    if "None" in Embed.fields[length].value:
        Embed.set_field_at(length, name=Embed.fields[length].name, value=Embed.fields[length].value.replace(Embed.fields[length].value, interaction.user.mention), inline=Embed.fields[length].inline)

    else:
        Embed.set_field_at(length, name=Embed.fields[length].name, value=Embed.fields[length].value + "\n" + interaction.user.mention, inline=Embed.fields[length].inline)

    await interaction.message.edit(embed=Embed)

    if interaction.response.is_done():
        await interaction.followup.send("Als Bearbeiter eingetragen", ephemeral=True)
    else:
        await interaction.response.send_message("Als Bearbeiter eingetragen", ephemeral=True)

    return True



async def ghost_ping(interaction, channel, data):
    length = len(data["Config.Permissions"]["roles"])
    for i in range(0, length, 1):
        if data["Config.Permissions"]["roles"][i]["ghostping"] == True:
            role = interaction.guild.get_role(int(data["Config.Permissions"]["roles"][i]["roleid"]))
            ghostping = await channel.send(role.mention)
            await ghostping.delete(delay=0.85)



async def single_ghost_ping(interaction, channel, member):
    ghostping = await channel.send(member.mention)
    await ghostping.delete(delay=0.85)


async def check_existing_button(channel, button_label):
    async for message in channel.history(limit=None):

        if isinstance(message, discord.Message):
            for component in message.components:
                if isinstance(component, discord.ActionRow):
                    for button in component.children:
                        if isinstance(button, discord.Button):
                            if button.label == button_label:
                                return True

                elif isinstance(component, discord.Button):
                    if component.label == button_label:
                        return True

    return False



async def addon_integration(interaction, data, servername):
    print("test")



class TicketButton(discord.ui.Button):
    def __init__(self, servername):
        self.server = servername
        with open(fr'{path}/Configs/{servername}/tickets.yaml', encoding='utf8') as f:
            data = yaml.load(f, Loader=SafeLoader)

        super().__init__(
            emoji=f'{data["Config.Button"]["ticketbutton"]["emoji"]}',
            label=f'{data["Config.Button"]["ticketbutton"]["label"]}', 
            style=int(data["Config.Button"]["ticketbutton"]["style"]),
            disabled=data["Config.Button"]["ticketbutton"]["disabled"],
            custom_id=f'interaction:{self.__class__.__name__}',
        )

    async def callback(self, interaction = discord.Interaction):
        user = interaction.user
        with open(fr'{path}/Configs/server.yaml', encoding='utf8') as f:
            data = yaml.load(f, Loader=SafeLoader)
        try:
            servername = next(item["name"] for item in data["Config.Server"] if str(interaction.guild.id) == str(item["guild"]))
        except StopIteration:
            return
        
        await interaction.response.defer(invisible=False, ephemeral=True)

        with open(fr'{path}/Configs/{servername}/tickets.yaml', encoding='utf8') as f:
            data = yaml.load(f, Loader=SafeLoader)

        for addon in data["Config.Addons"]:
            if addon["active"] == True:
                await addon_integration(interaction, data, servername)
                return

        else:
            if data["Config.ChannelisForum"] == True:
                threadheader = await create_threadheader(interaction, user, data, servername)

                if threadheader is not False:
                    threadback = await create_thread(interaction, user, data, threadheader)

                    if threadback is not False:
                        awswerback = await send_answermessage(interaction, user, None, threadback, data, servername)

                        if awswerback is not False:
                            singlegohstback = await single_ghost_ping(interaction, threadback, interaction.user) 

                        if singlegohstback is not False and data["Config.Ghostpings"] == True:
                            await ghost_ping(interaction, threadback, data)

                        await send_threadmessage(interaction, user, threadback, data, servername)
            
            else:
                createback = await create_ticket(interaction, user, data)

                if createback is not False:
                    overwriteback = await overwrite_ticket(interaction, user, createback, data)

                    if overwriteback is not False:
                        awswerback = await send_answermessage(interaction, user, createback, None, data, servername)

                        if awswerback is not False:
                            await send_ticketmessage(interaction, user, createback, data, servername)



class TicketInviteButton(discord.ui.Button):
    def __init__(self, servername):
        self.server = servername
        with open(fr'{path}/Configs/{servername}/tickets.yaml', encoding='utf8') as f:
            data = yaml.load(f, Loader=SafeLoader)

        super().__init__(
            emoji=f'{data["Config.Button"]["ticketinvitebutton"]["emoji"]}',
            label=f'{data["Config.Button"]["ticketinvitebutton"]["label"]}', 
            style=int(data["Config.Button"]["ticketinvitebutton"]["style"]),
            disabled=data["Config.Button"]["ticketinvitebutton"]["disabled"],
            custom_id=f'interaction:{self.__class__.__name__}',
        )

    async def callback(self, interaction: discord.Interaction):
        user = interaction.user
        with open(fr'{path}/Configs/server.yaml', encoding='utf8') as f:
            data = yaml.load(f, Loader=SafeLoader)
        try:
            servername = next(item["name"] for item in data["Config.Server"] if str(interaction.guild.id) == str(item["guild"]))
        except StopIteration:
            return
        
        with open(fr'{path}/Configs/{servername}/tickets.yaml', encoding='utf8') as f:
            data = yaml.load(f, Loader=SafeLoader)

        existing_button = await check_existing_button(interaction.channel, data["Config.Button"]["ticketinviteacceptbutton"]["label"])

        if existing_button == False:
            await interaction.response.send_modal(TicketInviteModal(title=f'{data["Config.Modal"]["ticketinvitemodal"]["title"]}', interaction=interaction, servername=servername)) 

        else:
            if interaction.response.is_done():
                await interaction.followup.send("Sie haben bereits eine Einladungsanfrage gesendet. Warten Sie bis ein Supporter Ihre Anfrage bearbeitet hat.", ephemeral=True)
            else:
                await interaction.response.send_message("Sie haben bereits eine Einladungsanfrage gesendet. Warten Sie bis ein Supporter Ihre Anfrage bearbeitet hat.", ephemeral=True)



class TicketInviteModal(discord.ui.Modal):
    def __init__(self, interaction, servername, *args, **kwargs) -> None:
        super().__init__(*args, **kwargs)
        self.interaction = interaction
        self.server = servername
        with open(fr'{path}/Configs/{servername}/tickets.yaml', encoding='utf8') as f:
            data = yaml.load(f, Loader=SafeLoader)
            length = len(data["Config.Modal"]["ticketinvitemodal"]["fields"])

        for i in range(0, length, 1):
            if data["Config.Modal"]["ticketinvitemodal"]["fields"][i]["type"] == "short":
                self.add_item(discord.ui.InputText(label=data["Config.Modal"]["ticketinvitemodal"]["fields"][i]["label"], placeholder=data["Config.Modal"]["ticketinvitemodal"]["fields"][i]["placeholder"], required=data["Config.Modal"]["ticketinvitemodal"]["fields"][i]["required"], style=discord.InputTextStyle.short))

            elif data["Config.Modal"]["ticketinvitemodal"]["fields"][i]["type"] == "long":
                self.add_item(discord.ui.InputText(label=data["Config.Modal"]["ticketinvitemodal"]["fields"][i]["label"], placeholder=data["Config.Modal"]["ticketinvitemodal"]["fields"][i]["placeholder"], required=data["Config.Modal"]["ticketinvitemodal"]["fields"][i]["required"], style=discord.InputTextStyle.long))

            else:
                return False


    async def callback(self, interaction: discord.Interaction):
        user = interaction.user
        with open(fr'{path}/Configs/server.yaml', encoding='utf8') as f:
            data = yaml.load(f, Loader=SafeLoader)
        try:
            servername = next(item["name"] for item in data["Config.Server"] if str(interaction.guild.id) == str(item["guild"]))
        except StopIteration:
            return
        
        with open(fr'{path}/Configs/{servername}/tickets.yaml', encoding='utf8') as f:
            data = yaml.load(f, Loader=SafeLoader)
        
        await interaction.response.defer(invisible=False)

        member = []

        for i in range(0, 4, 1):
            if self.children[i].value is not None:
                if self.children[i].value.isdigit():
                    try:
                        m = interaction.client.get_user(int(self.children[i].value))
                        if str(m.id) != str(interaction.user.id):
                            member.append(m)
                    except AttributeError and ValueError:
                        pass
                    
        await send_invitemessage(interaction, user, member, interaction.channel, data, servername)



class TicketInviteAcceptButton(discord.ui.Button):
    def __init__(self, servername):
        self.server = servername
        with open(fr'{path}/Configs/{servername}/tickets.yaml', encoding='utf8') as f:
            data = yaml.load(f, Loader=SafeLoader)

        super().__init__(
            emoji=f'{data["Config.Button"]["ticketinviteacceptbutton"]["emoji"]}',
            label=f'{data["Config.Button"]["ticketinviteacceptbutton"]["label"]}', 
            style=int(data["Config.Button"]["ticketinviteacceptbutton"]["style"]),
            disabled=data["Config.Button"]["ticketinviteacceptbutton"]["disabled"],
            custom_id=f'interaction:{self.__class__.__name__}',
        )

    async def callback(self, interaction: discord.Interaction):
        user = interaction.user
        with open(fr'{path}/Configs/server.yaml', encoding='utf8') as f:
            data = yaml.load(f, Loader=SafeLoader)
        try:
            servername = next(item["name"] for item in data["Config.Server"] if str(interaction.guild.id) == str(item["guild"]))
        except StopIteration:
            return
        
        await interaction.message.delete()
        
        await interaction.response.defer(invisible=False, ephemeral=True)
        
        with open(fr'{path}/Configs/{servername}/tickets.yaml', encoding='utf8') as f:
            data = yaml.load(f, Loader=SafeLoader)
            length = len(data["Config.Permissions"]["roles"])

        for i in range(0, length, 1):
            role = interaction.guild.get_role(int(data["Config.Permissions"]["roles"][i]["roleid"]))

            if role in user.roles:
                returninvite = await invite_member(interaction, interaction.message.embeds[0], data)
                break

        else:
            if interaction.response.is_done():
                await interaction.followup.send("You are not allowed to do this!", ephemeral=True)
            else:
                await interaction.response.send_message("You are not allowed to do this!", ephemeral=True)






class TicketInviteDeclineButton(discord.ui.Button):
    def __init__(self, servername):
        self.server = servername
        with open(fr'{path}/Configs/{servername}/tickets.yaml', encoding='utf8') as f:
            data = yaml.load(f, Loader=SafeLoader)

        super().__init__(
            emoji=f'{data["Config.Button"]["ticketinvitedeclinebutton"]["emoji"]}',
            label=f'{data["Config.Button"]["ticketinvitedeclinebutton"]["label"]}', 
            style=int(data["Config.Button"]["ticketinvitedeclinebutton"]["style"]),
            disabled=data["Config.Button"]["ticketinvitedeclinebutton"]["disabled"],
            custom_id=f'interaction:{self.__class__.__name__}',
        )

    async def callback(self, interaction: discord.Interaction):
        user = interaction.user
        with open(fr'{path}/Configs/server.yaml', encoding='utf8') as f:
            data = yaml.load(f, Loader=SafeLoader)
        try:
            servername = next(item["name"] for item in data["Config.Server"] if str(interaction.guild.id) == str(item["guild"]))
        except StopIteration:
            return
        
        await interaction.message.delete()
        
        await interaction.response.defer(invisible=False, ephemeral=True)

        with open(fr'{path}/Configs/{servername}/tickets.yaml', encoding='utf8') as f:
            data = yaml.load(f, Loader=SafeLoader)
            length = len(data["Config.Permissions"]["roles"])

        for i in range(0, length, 1):
            role = interaction.guild.get_role(int(data["Config.Permissions"]["roles"][i]["roleid"]))

            if role in user.roles:
                if interaction.response.is_done():
                    await interaction.followup.send("Invite Decline", ephemeral=True)
                else:
                    await interaction.response.send_message("Invite Decline", ephemeral=True)
                break

        else:
            if interaction.response.is_done():
                await interaction.followup.send("You are not allowed to do this!", ephemeral=True)
            else:
                await interaction.response.send_message("You are not allowed to do this!", ephemeral=True)



class TicketAddEditorButton(discord.ui.Button):
    def __init__(self, servername):
        self.server = servername
        with open(fr'{path}/Configs/{servername}/tickets.yaml', encoding='utf8') as f:
            data = yaml.load(f, Loader=SafeLoader)

        super().__init__(
            emoji=f'{data["Config.Button"]["ticketaddeditorbutton"]["emoji"]}',
            label=f'{data["Config.Button"]["ticketaddeditorbutton"]["label"]}', 
            style=int(data["Config.Button"]["ticketaddeditorbutton"]["style"]),
            disabled=data["Config.Button"]["ticketaddeditorbutton"]["disabled"],
            custom_id=f'interaction:{self.__class__.__name__}',
        )

    async def callback(self, interaction: discord.Interaction):
        user = interaction.user
        with open(fr'{path}/Configs/server.yaml', encoding='utf8') as f:
            data = yaml.load(f, Loader=SafeLoader)
        try:
            servername = next(item["name"] for item in data["Config.Server"] if str(interaction.guild.id) == str(item["guild"]))
        except StopIteration:
            return
        
        await interaction.response.defer(invisible=False, ephemeral=True)

        with open(fr'{path}/Configs/{servername}/tickets.yaml', encoding='utf8') as f:
            data = yaml.load(f, Loader=SafeLoader)
            length = len(data["Config.Permissions"]["roles"])

        for i in range(0, length, 1):
            role = interaction.guild.get_role(int(data["Config.Permissions"]["roles"][i]["roleid"]))

            if role in user.roles:
                returnaddeditor = await add_editor(interaction, interaction.message.embeds[0], data)
                break

        else:
            if interaction.response.is_done():
                await interaction.followup.send("You are not allowed to do this!", ephemeral=True)
            else:
                await interaction.response.send_message("You are not allowed to do this!", ephemeral=True)



class TicketCloseButton(discord.ui.Button):
    def __init__(self, servername):
        self.server = servername
        with open(fr'{path}/Configs/{servername}/tickets.yaml', encoding='utf8') as f:
            data = yaml.load(f, Loader=SafeLoader)

        super().__init__(
            emoji=f'{data["Config.Button"]["ticketclosebutton"]["emoji"]}',
            label=f'{data["Config.Button"]["ticketclosebutton"]["label"]}', 
            style=int(data["Config.Button"]["ticketclosebutton"]["style"]),
            disabled=data["Config.Button"]["ticketclosebutton"]["disabled"],
            custom_id=f'interaction:{self.__class__.__name__}',
        )

    async def callback(self, interaction: discord.Interaction):

        await interaction.channel.delete()



def setup(bot):
    bot.add_cog(Tickets(bot))